"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getMod = exports.login_logout = exports.voicerates = exports.cursess = exports.accountservice = exports.sessiondata = void 0;
const https_1 = __importDefault(require("https"));
const http_1 = __importDefault(require("http"));
const express_1 = __importDefault(require("express"));
const body_parser_1 = __importDefault(require("body-parser"));
const path_1 = __importDefault(require("path"));
const fs_1 = __importDefault(require("fs"));
const hashmap_1 = __importDefault(require("hashmap"));
const cookie_parser_1 = __importDefault(require("cookie-parser"));
const Session_1 = require("./lib/model/Session");
var cron = require("node-cron");
var net = require('net');
const CRLF = "\r\n";
const END = "\r\n\r\n";
var client = new net.Socket();
const setting_config_1 = require("./config/setting.config");
const _406_1 = require("./lib/view/406");
const module_config_1 = require("./config/module.config");
const swagger_ui_express_1 = __importDefault(require("swagger-ui-express"));
const yamljs_1 = __importDefault(require("yamljs"));
//const webPush = require('web-push');
// import Logger from "./lib/logger";
//import * as swaggerJsonDocument from './swagger.json'
const vs_server = new setting_config_1.VoiceServer();
const setting = new setting_config_1.Setting();
const yml = new setting_config_1.YMLDirectory();
exports.sessiondata = new hashmap_1.default();
exports.accountservice = new hashmap_1.default();
exports.cursess = new Session_1.CurrentSession();
exports.voicerates = new hashmap_1.default();
exports.login_logout = new hashmap_1.default();
exports.getMod = new module_config_1.modData();
const publicVapidKey = 'BD_yi09adiQ76ww2y0GhOfju17mTj2jxImFyjHewQLXtUhHB_zVHGiaEtlO3ryB7ZIB6S0k3Fob6t_uMfp8ooLU';
const privateVapidKey = 'dDk80jjMwpUdUXceCZ7X9jax9qNO6YUmWuzZop7KIqg';
//webPush.setVapidDetails('mailto:rv547727@gmail.com', publicVapidKey, privateVapidKey);
/** To generate the dynamic smsid for synverse */
exports.sessiondata.set("smscID", 4);
const app = (0, express_1.default)();
// app.use(bodyParser.urlencoded({ limit: "50mb", extended: true, parameterLimit: 50000 }));
app.use(body_parser_1.default.json({ limit: '50mb' }));
app.use(body_parser_1.default.urlencoded({ limit: '50mb', extended: true }));
app.use(body_parser_1.default.json());
app.use((0, cookie_parser_1.default)());
app.use(function (req, res, next) {
    res.header("Access-Control-Allow-Origin", "*");
    res.header("Access-Control-Allow-Headers", "Origin, X-Requested-With, Content-Type, Accept, Authorization");
    res.header('Access-Control-Allow-Methods', 'GET, POST, OPTIONS, PUT, PATCH, DELETE');
    next();
});
app.use("/uploads", express_1.default.static(path_1.default.join(__dirname, "uploads")));
const swaggerDocument = yamljs_1.default.load(process.cwd() + "/swagger/testing.yml");
// const swaggerDocument = YMLJS.load(process.cwd() + "/swagger/imported-numbers-hosting-orders-oas3 Apr26 (2).yml");
var options = {
    customCss: `
    .topbar-wrapper img {content:url('https://portal.signalmash.com/assets/img/logo-left-white.png'); width:300px; height:auto;}
    .swagger-ui .topbar { background-color: black;}`,
    customSiteTitle: "Signalmash API Documentation",
    customfavIcon: "https://portal.signalmash.com/assets/img/icon.png"
};
app.use('/doc', swagger_ui_express_1.default.serve, swagger_ui_express_1.default.setup(swaggerDocument, options));
app.use((req, res, next) => {
    let url = req.url.split("?");
    /*   if (url[0] == "/login" || url[0] == "/delete-user" ||  url[0] == "/apilogin" || url[0] == "smsdelivery" || url[0] == "/signup" || url[0] == '/forgot-mail' || url[0] == "/verify-token" || url[0] == "/update-password" || url[0] == "/emailverify" || url[0] == "/callbackmms/v1/sinch_mms" || url[0] == "/callbackdlr/v1/sinch_dlr"  || url[0] == "/restore-account" || url[0] == "/voltauth" || url[0] == "/send-notification" || url[0] == "/enhancedVettingReport" || url[0] == "/webhook_stripe") {
     */
    if (url[0] == "/login" || url[0] == "/delete-user" || url[0] == "/apilogin" || url[0] == "smsdelivery" || url[0] == "/signup" || url[0] == '/forgot-mail' || url[0] == "/verify-token" || url[0] == "/update-password" || url[0] == "/emailverify" || url[0] == "/callbackmms/v1/sinch_mms" || url[0] == "/callbackdlr/v1/sinch_dlr" || url[0] == "/restore-account" || url[0] == "/voltauth" || url[0] == "/enhancedVettingReport" || url[0] == "/verify-url") {
        next();
    }
    else {
        if (req.method == "OPTIONS") {
            res.status(200).send();
        }
        else {
            let sess = new Session_1.SessionManagment(req, res, next);
            sess.GetSession((error, data) => {
                if (error == 1) {
                    exports.cursess.session = data;
                    exports.cursess.error = 0;
                    //Logger.info(JSON.stringify({"info": {endpoint : url[0],"Current Session" : cursess.session.authkey, request: {requestQuery:req.query,requestBody:req.body}}}));
                }
                else {
                    let objv = new _406_1.Res406(res);
                    objv.prepare({ message: "Error in session" });
                    objv.execute();
                }
                next();
            });
        }
    }
});
//app.use(session({secret:"gventureworksforyou", resave: false, saveUninitialized: false}));
var routes = require('./routes/routes.class'); //importing route
/*if(vs_server.TYPE.toLowerCase()=="freeswitch")
{
  client.connect(vs_server.PORT, vs_server.HOST, function () {
    console.log('CONNECTED TO: ' + vs_server.HOST + ':' + vs_server.PORT);
    client.write('auth '+vs_server.PASS+'\n\n');
    console.log("Password : "+vs_server.PASS);
  });
}

if(vs_server.TYPE.toLowerCase()=="asterisk"){
  client.connect(vs_server.PORT, vs_server.HOST, function () {
    console.log('CONNECTED TO: ' + vs_server.HOST + ':' + vs_server.PORT);
    var obj = { Action: 'Login', Username: vs_server.USER, Secret: vs_server.PASS, ActionID:1};
    var str = '';
    Object.entries(obj).forEach(([key, value]) => {
        str += (key + ": " + value + CRLF);
    });
    str+=CRLF;
    client.write(str, 'ascii');
  });
}*/
//HTTPS server
if (setting.HTTPS) {
    const options = {
        key: fs_1.default.readFileSync(setting.KEY),
        cert: fs_1.default.readFileSync(setting.CERT)
    };
    let serversocket = new https_1.default.Server(options);
    serversocket = https_1.default.createServer(options, app);
    if (vs_server.TYPE != "none") {
        const io = require("socket.io").listen(serversocket);
        //var iosocket = new SocketIO(io, client); 
    }
    app.set("port", process.env.PORT || setting.PORT);
    routes(app); //register the route
    const server = serversocket.listen(app.get("port"), setting.DOMAIN, () => {
        console.log("  App is running at https://%s:%d in %s mode", setting.DOMAIN, app.get("port"), app.get("env"));
        console.log("  Press CTRL-C to stop\n");
    });
}
//HTTP server generation setting with complete socket
else {
    let serversocket = new http_1.default.Server();
    serversocket = http_1.default.createServer(app);
    if (vs_server.TYPE != "none") {
        const io = require("socket.io").listen(serversocket);
        //var iosocket = new SocketIO(io, client); 
    }
    app.set("port", process.env.PORT || setting.PORT);
    routes(app); //register the route
    const server = serversocket.listen(app.get("port"), setting.DOMAIN, () => {
        console.log("App is running at http://%s:%d in %s mode", setting.DOMAIN, app.get("port"), app.get("env"));
        console.log("Press CTRL-C to stop\n");
    });
}
